* Linear.sas;
options pageno=1 linesize=80;
goptions reset=all;
title 'Demonstration of expected value and variance rules';
data linear;
	* Loop to generate 100000 random observations;
	do i = 1 to 100000;
		a = 2;
		b = 1;
		* Generate y, y1, y2, y3 with N(1,2) distribution;
		mu = 1; sig2 = 1;
		y = sqrt(sig2)*rannor(0) + mu;
		y1 = sqrt(sig2)*rannor(0) + mu;
		y2 = sqrt(sig2)*rannor(0) + mu;
		y3 = sqrt(sig2)*rannor(0) + mu;
		* Calculate a linear function of y, then sum, mean, and s2;
		yprime = a*y + b;
		ysum = y1 + y2 + y3;
		ybar = ysum/3;
		s2 = ((y1-ybar)**2+(y2-ybar)**2+(y3-ybar)**2)/(3-1);
		output;
	end;
run;
* Print simulated data, first 25 observations;
proc print data=linear(obs=25);
run;
* Descriptive statistics, histograms, and normal quantile plots;
proc univariate data=linear;
	var y yprime ysum ybar s2;
	histogram y yprime ysum ybar s2 / vscale=count normal(w=3) haxis=axis1 vaxis=axis2 wbarline=3 waxis=3 height=4;
	qqplot y yprime ysum ybar s2 / normal waxis=3 height=4;
	symbol1 h=3;
	axis1 order=(-6 to 12 by 0.2);
	axis2 order=(0 to 10000 by 2000);
run;
quit;
